
clear; clc; 

WhereAreWe = cd; 
path(path,[WhereAreWe '\Data']);
path(path,[WhereAreWe '\Subcodes']);

COUNTRIES = ['CAN'; 'FRA'; 'DEU'; 'ITA'; 'JPN'; 'GBR'; 'USA'];

[Raw_QoQ_Data,RelatedInfoQoQ] = xlsread('OECD Data_v2.xlsx','QoQ');
RelatedInfoQoQ = RelatedInfoQoQ(2:end,:);

%% Construct QoQ Database
for jj = 1:size(COUNTRIES,1)
    FindCountry = strmatch(COUNTRIES(jj,:), RelatedInfoQoQ(:,1), 'exact');
    QoQ_DATA(:,jj) = Raw_QoQ_Data(FindCountry,1);
    % Calculate log Level from the growth rates
    DATALevel(:,jj) = log(cumprod([1; (1+QoQ_DATA(:,jj)/100)]));
    DATADetrended(:,jj)=DATALevel(:,jj) - RotembergDetrend(DATALevel(:,jj));
    close all 
    
    GDPdet_QoQ(:,jj) = DATADetrended(2:end,jj)-DATADetrended(2-1:end-1,jj); 
    GDPdet_YoY(:,jj) = DATADetrended(5:end,jj)-DATADetrended(5-4:end-4,jj); 
    
end

%% CALCULATE Skewness
LenghtSample = 4*8;                 %% Fix Window Size

for jj=1:size(COUNTRIES,1)
    
    for ttt = LenghtSample+1:size(GDPdet_YoY,1)
    %% Calculate Stats QoQ     
    XX = GDPdet_QoQ(ttt-LenghtSample:ttt,jj);
    SkewnessPanelQoQ(ttt,jj) = skewness(XX);
    
    PosSemiVar = sum((XX(XX>=mean(XX))-mean(XX)).^2)/(size(XX,1)-1);
    NegSemiVar = sum((XX(XX<mean(XX))-mean(XX)).^2)/(size(XX,1)-1);
    RelativeVariancePanelQoQ(ttt,jj) = sqrt(NegSemiVar)/sqrt(PosSemiVar);
    
    
    end    
    
end

%% Fill Beginning of Sample with NaN
SkewnessPanelQoQ(1:LenghtSample,:)= NaN;
RelativeVariancePanelQoQ(1:LenghtSample,:)= NaN;

%% Pick end of year values
SkewnessPanelQoQ = SkewnessPanelQoQ([2:4:size(SkewnessPanelQoQ,1)],:);
RelativeVariancePanelQoQ = RelativeVariancePanelQoQ([2:4:size(RelativeVariancePanelQoQ,1)],:);

%% Loose last observation
SkewnessPanelQoQ = SkewnessPanelQoQ(1:end-2,:);
RelativeVariancePanelQoQ = RelativeVariancePanelQoQ(1:end-2,:);

save saveRollingData_International SkewnessPanelQoQ RelativeVariancePanelQoQ 
